' This WILL fit on a vanilla Picaxe08 in case we need it to, also,

'
' Pins 1, 2 and 3 are parallel input -- see control table below.
' Pin 4 is serial input and accept values ascii0 to ascii7 to do the same thing.
' A character must be sent before pin4 takes in data (this uses an interrupt).
'
'

symbol CAR_OUT = 0 ' output to RC car controller -- tap where the radio receiver is

symbol REV = 50 * 2
symbol BRAKE = 110 * 2' for throttle, it's a little off
symbol FWD = 150 * 2

symbol RIGHT = 50 * 2
symbol STRAIGHT = 100 * 2' use trim on side of car to calibrate this
symbol LEFT = 150 * 2


symbol Flip = bit0
symbol PADDING = w3
symbol STEERING = w4 ' w6
symbol THROTTLE = w5 ' w6

symbol DELAY = 450 * 2

init:

setfreq m8


high CAR_OUT

begin:
if Flip = 0 then
  pulsin 1, 1, THROTTLE
  Flip = 1
  PADDING = DELAY-THROTTLE 
  THROTTLE = THROTTLE * 2 / 3 + 50
else
  pulsin 2, 1, STEERING
  Flip = 0
  PADDING = DELAY-STEERING
  STEERING = STEERING * 2 / 3 + 20 '28 / 30 - 20'* 2 / 3 + 80
endif

pulsout 4,PADDING ' equalizes delay


if THROTTLE = 0 or STEERING = 0 then goto init

'STEERING = 280 ' these are the "zeros"
'THROTTLE = 280 ' these are the "zeros"


'pause 8

'now, send stuff to car
low CAR_OUT
pulsout CAR_OUT,THROTTLE
low CAR_OUT
pulsout CAR_OUT,STEERING
high CAR_OUT


goto begin




